﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Framework
{
    /// <summary>
    /// 処理時間計測のためのクラスです。
    /// </summary>
    public class PerformanceChecker
    {
        /// <summary>
        /// act の処理にかかった時間（ミリ秒単位）を返します。
        /// </summary>
        /// <example>
        /// var t = PerformanceChecker.Check(() => { 時間のかかる処理  });
        /// </example>
        /// <param name="act"></param>
        /// <returns></returns>
        public static long Check(Action act)
        {
            var sw = System.Diagnostics.Stopwatch.StartNew();

            act();

            sw.Stop();

            return sw.ElapsedMilliseconds;
        }

        /// <summary>
        /// act の処理を times回に実施するのにかかった時間（ミリ秒単位）を返します。
        /// </summary>
        /// <remarks>
        /// Actionの呼び出しでちょこっと計測時間が加算されるので注意。以前計測したときは100万回で25ms程度でした。
        /// </remarks>
        /// <param name="act"></param>
        /// <param name="times">実施回数</param>
        /// <returns></returns>
        public static long Check(Action<int> act, int times)
        {
            var sw = System.Diagnostics.Stopwatch.StartNew();

            for (int i = 0; i < times; i++)
            {
                act(i);
            }

            sw.Stop();

            return sw.ElapsedMilliseconds;
        }
    }
}
